<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    * 
    * Classe per gestire un portfolio.
    * NB: dato che gli elementi del portfolio sono un tip di contenuti la creazione di questi elementi viene fatta
    * nnel file controllerContenuti.php e non viene gestita da questa classe
    */

    class Portfolio {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $descrizione;
        private $etichettaAltriElementi;
        private $linkPagina;
        private $filtrabile;
        private $senzaBordi;
        private $classeElementi;
        private $mostraNomiElementi;
        private $aspetto;
        private $aspectRatio;
        private $mostraImmagineInEvidenza;
        private $traduzioneItaliano;
        private $traduzioneInglese;
        private $traduzioneTedesco;
        private $traduzioneFrancese;
        private $traduzioneSpagnolo;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="", $descrizione="", $etichettaAltriElementi="", $linkPagina="", $filtrabile="", $senzaBordi="", $classeElementi="", $mostraNomiElementi = "", $aspetto = "", $aspectRatio="", $mostraImmagineInEvidenza="", $traduzioneItaliano=0, $traduzioneInglese=0, $traduzioneTedesco=0, $traduzioneFrancese=0, $traduzioneSpagnolo=0) {
            $this->db             = $db;
            $this->id             = $id;
            $this->nome           = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->descrizione    = $descrizione;
            $this->etichettaAltriElementi = $etichettaAltriElementi;
            $this->linkPagina     = $linkPagina;
            $this->filtrabile     = $filtrabile;
            $this->senzaBordi     = $senzaBordi;
            $this->classeElementi = $classeElementi;
            $this->mostraNomiElementi       = $mostraNomiElementi;
            $this->aspetto                  = $aspetto;
            $this->aspectRatio              = $aspectRatio;
            $this->mostraImmagineInEvidenza = $mostraImmagineInEvidenza;
            $this->traduzioneItaliano       = $traduzioneItaliano;
            $this->traduzioneInglese        = $traduzioneInglese;
            $this->traduzioneTedesco        = $traduzioneTedesco;
            $this->traduzioneFrancese       = $traduzioneFrancese;
            $this->traduzioneSpagnolo       = $traduzioneSpagnolo;
        }

        function crea() {
            $query    = "INSERT INTO geec_portfolio VALUES(NULL,'$this->nome','$this->spazioOccupato','$this->descrizione', '$this->etichettaAltriElementi', '$this->linkPagina','$this->filtrabile','$this->senzaBordi','$this->classeElementi','$this->mostraNomiElementi','$this->aspetto','$this->aspectRatio','$this->mostraImmagineInEvidenza',$this->traduzioneItaliano,$this->traduzioneInglese,$this->traduzioneTedesco,$this->traduzioneFrancese,$this->traduzioneSpagnolo)";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_portfolio SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', descrizione='$this->descrizione', etichettaAltriElementi='$this->etichettaAltriElementi', linkPagina='$this->linkPagina', filtrabile='$this->filtrabile', senzaBordi='$this->senzaBordi', classeElementi='$this->classeElementi', mostraNomiElementi='$this->mostraNomiElementi', aspetto='$this->aspetto',  aspectRatio='$this->aspectRatio', mostraImmagineInEvidenza='$this->mostraImmagineInEvidenza', traduzioneItaliano='$this->traduzioneItaliano', traduzioneInglese='$this->traduzioneInglese', traduzioneTedesco='$this->traduzioneTedesco', traduzioneFrancese='$this->traduzioneFrancese', traduzioneSpagnolo='$this->traduzioneSpagnolo' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
            
            // imposto la lingua degli elementi del portfolio
            $this->modificaLinguaElementi();
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_portfolio",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 
            $queryEliminaOccorrenzeComposizionePagine = "DELETE FROM geecB_composizionePagine WHERE idElemento = $this->id AND idComponente = 22";
            $this->db->eseguiQueryScrittura($queryEliminaOccorrenzeComposizionePagine);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_portfolio VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geecB_contenuti WHERE idForm='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geecB_contenuti` (`id`, `idForm`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function caricaDatiDalDatabase() {
            $datiForm   = $this->db->leggiSingolaRiga("geec_portfolio",$this->id);
            $this->nome                     = $datiForm["nome"];
            $this->spazioOccupato           = $datiForm["spazioOccupato"];
            $this->descrizione              = $datiForm["descrizione"];
            $this->etichettaAltriElementi   = $datiForm["etichettaAltriElementi"];
            $this->linkPagina               = $datiForm["linkPagina"];
            $this->filtrabile               = $datiForm["filtrabile"];
            $this->senzaBordi               = $datiForm["senzaBordi"];
            $this->classeElementi           = $datiForm["classeElementi"];
            $this->mostraNomiElementi       = $datiForm["mostraNomiElementi"];
            $this->aspetto                  = $datiForm["aspetto"];
            $this->aspectRatio              = $datiForm["aspectRatio"];
            $this->mostraImmagineInEvidenza = $datiForm["mostraImmagineInEvidenza"];
            $this->traduzioneItaliano       = $datiForm["traduzioneItaliano"];
            $this->traduzioneInglese        = $datiForm["traduzioneInglese"];
            $this->traduzioneTedesco        = $datiForm["traduzioneTedesco"];
            $this->traduzioneFrancese       = $datiForm["traduzioneFrancese"];
            $this->traduzioneSpagnolo       = $datiForm["traduzioneSpagnolo"];
        }
        
        function stampaElementi() {
            $impostazioni = recuperaImpostazioni($this->db);
            $query = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'elementoPortfolio' AND contenutoRiferimento={$this->id} ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($elemento = $risultatoQuery->fetch_assoc()) {
                
                $posizionePrecedente = ($elemento["posizione"]<=1) ? 1 : $elemento["posizione"] - 1;
                $posizioneSuccesiva  = $elemento["posizione"] +1;
            ?>
                <div id="elementoComponente<?php echo $elemento["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded">
                    <div class="form-row">
                        <div class="col-xl-3 mb-2 mb-xl-0">
                            <div class="aspect-ratio-21-9">
                                <img src="../../../<?php echo (($elemento["foto"]!="") ? $elemento["foto"] : "immagini/altro/segnaposto.png") ?>">
                            </div>
                        </div>
                        <div class="col-md-8 col-xl-5 align-self-center mb-2 mb-md-0">
                            <p class="mb-0"><em><a href="creaElemento.php?id=<?php echo $elemento["id"] ?>"><strong><?php echo $elemento["titolo"] ?></strong></a></em>  </p>
                            <small class="text-muted"><em><?php echo GeneratoreUrl::creaUrlContenuto($elemento, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"])?></em>  </small>
                        </div>
                        <div class="col-md-4 col-xl-2 align-self-center">
                            <form>
                                <div class="input-group input-group-sm d-flex align-items-center">
                                    <small class="text-muted mr-2">Pos.</small>
                                    <input type="number" id="nuovaPosizioneElemento<?php echo $elemento["id"] ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $elemento["posizione"] ?>">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $elemento["id"] ?>)">Salva</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-xl-2 align-self-center text-right azioni">
                            <div class="btn-group" role="group" aria-label="Basic example">
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"] ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"] ?>,<?php echo $posizioneSuccesiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="location.href='creaElemento.php?id=<?php echo $elemento["id"]; ?>';" data-original-title="Configura elemento"><i class="fas fa-cog"></i></button>
                                <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaElemento(<?php echo $elemento["id"]; ?>,'<?php echo filter_var($elemento["titolo"],FILTER_SANITIZE_ADD_SLASHES) ?>','link')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                            </div>    
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function stampaElencoCategorie() {
            $query = "SELECT * FROM `geec_categorie` WHERE tipo LIKE 'categoriaPortfolio' AND categoriaMadre=$this->id";
            $risCategorie = $this->db->eseguiQueryLettura($query);
            
            while($categoria = $risCategorie->fetch_assoc()) {
                $numeroElementiNellaCategoria = $this->db->contaRigheTabella("geecB_contenuti",array("categoria"=>$categoria["id"]));
                $nomeEscape = filter_var($categoria["nome"],FILTER_SANITIZE_ADD_SLASHES);
                
                echo"<div id=\"categoria{$categoria["id"]}\" class=\"col-sm-6 col-lg-4\">
                        <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                            <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                                <p class=\"mb-0\"><em><strong>{$categoria["nome"]}</strong></em>  </p>
                                <small><em>$numeroElementiNellaCategoria elementi</em></small>
                            </div>
                            <div class=\"azioni d-flex align-items-center justify-content-end\">
                                <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\" onclick=\"modificaCategoria({$categoria["id"]},'$nomeEscape')\"><i class=\"far fa-edit\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaCategoria({$categoria["id"]},'$nomeEscape')\" ><i class=\"far fa-trash-alt\"></i></button>
                                </div>
                           </div>
                        </div>
                    </div>";
            }
        }
        
        function spostaElemento($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'elementoPortfolio' AND contenutoRiferimento={$this->id} AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geecB_contenuti SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geecB_contenuti SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function modificaLinguaElementi() {
            if($this->traduzioneItaliano==0) {
                $query = "UPDATE geecB_contenuti SET linguaContenuto = 'italiano' WHERE tipo LIKE 'elementoPortfolio' AND contenutoRiferimento=$this->id";
            }
            else if($this->traduzioneInglese==0) {
                $query = "UPDATE geecB_contenuti SET linguaContenuto = 'inglese' WHERE tipo LIKE 'elementoPortfolio' AND contenutoRiferimento=$this->id";
            }
            else if($this->traduzioneTedesco==0) {
                $query = "UPDATE geecB_contenuti SET linguaContenuto = 'tedesco' WHERE tipo LIKE 'elementoPortfolio' AND contenutoRiferimento=$this->id";
            }
            else if($this->traduzioneFrancese==0) {
                $query = "UPDATE geecB_contenuti SET linguaContenuto = 'francese' WHERE tipo LIKE 'elementoPortfolio' AND contenutoRiferimento=$this->id";
            }
            else if($this->traduzioneSpagnolo==0) {
                $query = "UPDATE geecB_contenuti SET linguaContenuto = 'spagnolo' WHERE tipo LIKE 'elementoPortfolio' AND contenutoRiferimento=$this->id";
            }
            else { // se non è stata specificata una lingua per il portfolio i suoi elementi vengono impostati in italiano
                $query = "UPDATE geecB_contenuti SET linguaContenuto = 'italiano' WHERE tipo LIKE 'elementoPortfolio' AND contenutoRiferimento=$this->id";                
            }
            
            $this->db->eseguiQueryScrittura($query);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geecB_contenuti",$idElemento);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getDescrizione() {
            return $this->descrizione;
        }

        public function getEtichettaAltriElementi() {
            return $this->etichettaAltriElementi;
        }

        public function getLinkPagina() {
            return $this->linkPagina;
        }

        public function getFiltrabile() {
            return $this->filtrabile;
        }

        public function getSenzaBordi() {
            return $this->senzaBordi;
        }

        public function getClasseElementi() {
            return $this->classeElementi;
        }

        public function getMostraNomiElementi() {
            return $this->mostraNomiElementi;
        }
        
        public function getAspetto() {
            return $this->aspetto;
        }

        public function getAspectRatio() {
            return $this->aspectRatio;
        }

        public function getMostraImmagineInEvidenza() {
            return $this->mostraImmagineInEvidenza;
        }
        public function getTraduzioneItaliano() {
            return $this->traduzioneItaliano;
        }

        public function getTraduzioneInglese() {
            return $this->traduzioneInglese;
        }

        public function getTraduzioneTedesco() {
            return $this->traduzioneTedesco;
        }

        public function getTraduzioneFrancese() {
            return $this->traduzioneFrancese;
        }

        public function getTraduzioneSpagnolo() {
            return $this->traduzioneSpagnolo;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato): void {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setDescrizione($descrizione): void {
            $this->descrizione = $descrizione;
        }

        public function setEtichettaAltriElementi($etichettaAltriElementi): void {
            $this->etichettaAltriElementi = $etichettaAltriElementi;
        }
        
        public function setLinkPagina($linkPagina): void {
            $this->linkPagina = $linkPagina;
        }

        public function setFiltrabile($filtrabile): void {
            $this->filtrabile = $filtrabile;
        }

        public function setSenzaBordi($senzaBordi): void {
            $this->senzaBordi = $senzaBordi;
        }

        public function setClasseElementi($classeElementi): void {
            $this->classeElementi = $classeElementi;
        }

        public function setMostraNomiElementi($mostraNomiElementi): void {
            $this->mostraNomiElementi = $mostraNomiElementi;
        }

        public function setAspetto($aspetto): void {
            $this->aspetto = $aspetto;
        }
        
        public function setAspectRatio($aspectRatio): void {
            $this->aspectRatio = $aspectRatio;
        }

        public function setMostraImmagineInEvidenza($mostraImmagineInEvidenza): void {
            $this->mostraImmagineInEvidenza = $mostraImmagineInEvidenza;
        }
        
        public function setTraduzioneItaliano($traduzioneItaliano): void {
            $this->traduzioneItaliano = $traduzioneItaliano;
        }

        public function setTraduzioneInglese($traduzioneInglese): void {
            $this->traduzioneInglese = $traduzioneInglese;
        }

        public function setTraduzioneTedesco($traduzioneTedesco): void {
            $this->traduzioneTedesco = $traduzioneTedesco;
        }

        public function setTraduzioneFrancese($traduzioneFrancese): void {
            $this->traduzioneFrancese = $traduzioneFrancese;
        }

        public function setTraduzioneSpagnolo($traduzioneSpagnolo): void {
            $this->traduzioneSpagnolo = $traduzioneSpagnolo;
        }
    }